// sdt_cleaner -> Stable Version
// autor: +NCR/CRC! [ReVeRsEr] (nriva) - Core Security Technologies 2008
// greetz to: marciano, Saccopharynx, fruss, gera.
// compiler: Mingw -  Editor: Dev-C++ 4.9.9.2

#include <stdio.h>
#include <tchar.h>
#include <conio.h>
#include <windows.h>
#include "sdt_cleaner.h"
#include "callgates.c"

DWORD                    SdtAddrs[KI_SERVICE_LIMIT], SdtPtrs[KI_SERVICE_LIMIT], NumFixEntries = 0;
DWORD                    SdtAddrsFix[KI_SERVICE_LIMIT], SdtHooks[KI_SERVICE_LIMIT];
DWORD                    GdtRealAddrs, GdtAddrs;

int findRVAinSection(PeHeader *pe_header, SectionHeader *section_header, DWORD rva)
{
    int i;
    
    for(i = 0; i < pe_header->numSections; i++)
        if((section_header[i].virtualAddress <= rva) && 
             (rva <= section_header[i].virtualAddress + section_header[i].virtualSize))
           break;
    return i;   
}

LPVOID get_ntos_name_and_base(char *ntosname)
{
	HANDLE       hLib;
	PENUMDEVICES pEnumDeviceDrivers;
	PGETDEVNAME  pGetDeviceDriverBaseName;	
	DWORD        lpcbNeeded,i;
	LPVOID       NtosBase = NULL;
	LPVOID       *lpImageBases = NULL;

    hLib = LoadLibraryA("psapi.dll");
    pEnumDeviceDrivers = (PENUMDEVICES) GetProcAddress(hLib,"EnumDeviceDrivers");
    pGetDeviceDriverBaseName = (PGETDEVNAME) GetProcAddress(hLib,"GetDeviceDriverBaseNameA");
    
	if (hLib && pEnumDeviceDrivers && pGetDeviceDriverBaseName)
	{
		lpImageBases = malloc( sizeof(LPVOID) * NDRIVERS_LIST );
		pEnumDeviceDrivers(lpImageBases,sizeof(LPVOID) * NDRIVERS_LIST,&lpcbNeeded);
		
		if ( (lpcbNeeded / sizeof(LPVOID)) > NDRIVERS_LIST)
		{
			lpImageBases = realloc(lpImageBases,sizeof(LPVOID) * lpcbNeeded);
			pEnumDeviceDrivers(lpImageBases,lpcbNeeded,&lpcbNeeded);
		}				

		for (i = 0; i < (lpcbNeeded / sizeof(LPVOID)) ; i++ )
		{
			if ( pGetDeviceDriverBaseName(lpImageBases[i],ntosname,MAX_PATH) )
			{
				if ((!strcmp(ntosname,"ntoskrnl.exe")) || (!strcmp(ntosname,"ntkrnlpa.exe")))
				{					
					NtosBase = lpImageBases[i];
					break;
				}
			}				
		}

		free(lpImageBases);
	}

	else
	{
		printf("ERROR: Cannot Load psapi exports!\n");
	}
    return NtosBase;   
}

void get_ntospath(TCHAR* sys_path, char *ntosname)
{     
      if( !GetSystemDirectory( sys_path, INFO_BUFFER_SIZE ) )
      {
        printf("ERROR: GetSystemDirectory error!");
        exit(1);
      }
      strcat(sys_path,"\\");
      strcat(sys_path,ntosname);
}

DWORD get_windows_version(void)
{
      OSVERSIONINFO os_version;
      DWORD         version = 0;
      BOOL          ret_get_version;

      os_version.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
      
      ret_get_version = GetVersionExA(&os_version);
      
      if(ret_get_version)
      {
         if(os_version.dwMajorVersion == 5) //  w2k, w2k3, xp or 2003
         {
            switch(os_version.dwMinorVersion)
            {
              case 0: version = OS_W2K; break;
              case 1: version = OS_WXP; break;
              case 2: version = OS_W2K3; break;
            }
         }
         else if(os_version.dwMajorVersion == 6) // vista or 2008
         {
              version = OS_WVISTA;
         }
      }
      
      return version;         
}

DWORD getSdtAddrsAndPtrs(DWORD *sdt_ptr, int index)
{
  BOOL   answer;     
  HANDLE file_handle;
  MzHeader *mz_header;
  PeHeader *pe_header;
  PeExtHeader *pe_ext_header;
  SectionHeader *section_header;
  TCHAR  ntos_path[INFO_BUFFER_SIZE];
  ImageExportDirectory *image_export_dir;
  ImageBaseRelocation * imgBaseRelocEntry;
  BY_HANDLE_FILE_INFORMATION file_info;
  char   ntos_name[MAX_PATH + 1], temp[5];
  DWORD  file_low_size_part, to_read, sdt_address;     
  LPVOID ntos_base_address = NULL, file_buff, ntos_addr = NULL;
  
  ntos_base_address = get_ntos_name_and_base(ntos_name);
  
  get_ntospath(ntos_path, ntos_name);
  
  file_handle = CreateFile(ntos_path, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL);
  GetFileInformationByHandle(file_handle, &file_info);
  
  file_low_size_part  = file_info.nFileSizeLow;
  
  if(file_low_size_part)
  {
      if(file_handle != INVALID_HANDLE_VALUE)
      {
        file_buff = VirtualAlloc(NULL, file_low_size_part, MEM_COMMIT | MEM_RESERVE, PAGE_EXECUTE_READWRITE);
        if (file_buff)
        {
          ReadFile(file_handle, file_buff, file_low_size_part, &to_read, NULL);
          if(answer && to_read == file_low_size_part)
          {
            mz_header = (MzHeader *)file_buff;
            pe_header = (PeHeader *)(file_buff + mz_header->offsetToPE);
            pe_ext_header = (PeExtHeader *)(pe_header+1);
            section_header = (SectionHeader *)(pe_ext_header+1);
            
            if(mz_header->signature != IMAGE_DOS_SIGNATURE) // MZ 0x5a4d
            {
              printf("ERROR: File doesn't have MzHeader signature\n");
              exit(1);
            }
            
            if(pe_header->signature != IMAGE_NT_SIGNATURE) // PE 0x4550
            {
              printf("ERROR: File doesn't have PE signature\n");
              exit(1);       
            }  
            
            if(pe_header->sizeOfOptionHeader != sizeof(PeExtHeader))
            {
              printf("ERROR: PEHeader->SizeOfOptionalHeader != sizeof(PeExtHeader)\n");
              exit(1);
            }
            
            int i;
            i = findRVAinSection(pe_header, section_header, pe_ext_header->exportTableAddress);

            image_export_dir = (ImageExportDirectory *)((pe_ext_header->exportTableAddress - section_header[i].virtualAddress) + 
                                 section_header[i].pointerToRawData + file_buff);
                        
            DWORD *ExportNamesTablePointer = (DWORD *)((image_export_dir->addressOfNames - section_header[i].virtualAddress) +
                            section_header[i].pointerToRawData + file_buff);

            WORD *OrdinalTable = (WORD *)((image_export_dir->addressOfNameOrdinals - section_header[i].virtualAddress) + 
                           section_header[i].pointerToRawData + file_buff);
            DWORD *AddrOfFunction = (DWORD *)((image_export_dir->addressOfFunctions - section_header[i].virtualAddress) + 
                           section_header[i].pointerToRawData + file_buff);
                           
            char *name;
            int section_index, ret;
            WORD ordinal;
            DWORD funcRVA; 
            for(i=0; i < image_export_dir->numberOfNames; i++)
            { 
              section_index = findRVAinSection(pe_header, section_header, ExportNamesTablePointer[i]);
              name = (char *)((ExportNamesTablePointer[i] - section_header[section_index].virtualAddress) + 
                         section_header[section_index].pointerToRawData + file_buff);
              ret = strcmp("NtAddAtom", name);             
              if(ret == 0)
              {
                 ordinal = OrdinalTable[i];
                 funcRVA = AddrOfFunction[ordinal];
              }
            }
            
            if((pe_ext_header->relocationTableAddress) && (pe_ext_header->relocationTableSize))
            {
                i = findRVAinSection(pe_header, section_header, pe_ext_header->relocationTableAddress);
                
                imgBaseRelocEntry = (ImageBaseRelocation *)((pe_ext_header->relocationTableAddress - section_header[i].virtualAddress) + 
                                     section_header[i].pointerToRawData + file_buff);
                                     
                DWORD reloc_rva, *rva, *ptr_rva, sdt_function_rva, temp;
                WORD *offset;
                int num_entries, type_offset, j;
                while(imgBaseRelocEntry->sizeOfBlock)
                {
                   num_entries = (imgBaseRelocEntry->sizeOfBlock - sizeof(ImageBaseRelocation))/2;
                   offset = (WORD *)(imgBaseRelocEntry + 1);   
                   
                   for(i = 0; i < num_entries; i++)
                   {
                      type_offset = (*offset & 0xF000) >> 12;
                      if(type_offset == 3)
                      {
                         reloc_rva = ((*offset & 0x0FFF) + imgBaseRelocEntry->virtualAddress);
                         
                         j = findRVAinSection(pe_header, section_header, reloc_rva);

                         rva = (DWORD *)((reloc_rva - section_header[j].virtualAddress) + 
                                          section_header[j].pointerToRawData + file_buff);
                         if(*rva == (funcRVA + pe_ext_header->imageBase))
                         {
                            sdt_function_rva = reloc_rva - 0x20;
                         }  
                      offset++;
                      }
                   }
                imgBaseRelocEntry = (ImageBaseRelocation *)((char *)(imgBaseRelocEntry) + imgBaseRelocEntry->sizeOfBlock); //(*)
                }
            temp = sdt_function_rva + (index * 4);
            i = findRVAinSection(pe_header, section_header, temp);
            ptr_rva = (DWORD *)(temp - section_header[i].virtualAddress +
                                section_header[i].pointerToRawData + file_buff);  
            *sdt_ptr = (DWORD)(*ptr_rva - pe_ext_header->imageBase + ntos_base_address); 
            
            sdt_address = sdt_function_rva + (index * 4) + (DWORD)ntos_base_address;
            }
          }
          else printf("ERROR %x: Error reading file\n", GetLastError());   
        }
      }
      VirtualFree(file_buff, file_low_size_part, MEM_RELEASE);
  }   
  CloseHandle(file_handle);  
  return sdt_address;      
}

void RestoreSdtPtrs(void)
{
  asm volatile ("pusha");                                                 // pushad
  asm volatile ("pushf");                                                 // pushfd
  asm volatile ("cli");                                                   // cli
  asm volatile ("xorl %ecx,%ecx");                                        // xor ecx,ecx
  asm volatile ("xorl %edx,%edx");                                        // xor edx,edx
  asm volatile ("xorl %esi,%esi");                                        // xor esi,esi
  asm volatile ("loope: movl (%0),%%eax" : :"m"(SdtAddrs));               // loope: 
                                                                          // mov eax,[SdtAddrs]
  asm volatile ("movl (%eax,%edx),%eax");                                 // mov eax,[eax+edx]
  asm volatile ("movl (%0),%%ebx" : :"m"(SdtPtrs));                       // mov ebx,[SdtPtrs]
  asm volatile ("movl (%ebx,%edx),%ebx");                                 // mov ebx,[ebx+edx]
  asm volatile ("cmpl %ebx,(%eax)");                                      // cmp [eax],ebx
  asm volatile ("jnz restore_ptr");                                       // jnz retore_ptr
  asm volatile ("incl %ecx");                                             // inc ecx
  asm volatile ("addl %0,%%edx" : :"i"(4));                               // add edx,4
  asm volatile ("cmpl %0,%%ecx" : :"i"(KI_SERVICE_LIMIT));                // cmp ecx,KI_SERVICE_LIMIT
  asm volatile ("je ret_lejos");                                          // je ret_lejos
  asm volatile ("jmp loope");                                             // jmp loope
  asm volatile ("restore_ptr: mov (%0),%%edi" : :"m"(SdtAddrs));          // retore_ptr:
                                                                          // mov edi,[SdtPtrs]
  asm volatile ("movl (%edi,%edx),%edi");                                 // mov edi,[edi+edx]
  asm volatile ("movl %%edi,(%0)(%%esi)" :"=m"(SdtAddrsFix):);            // mov [esi+SdtAddrsFix],edi /* guardamos el addrs */
  asm volatile ("push %edi");                                             // push edi
  asm volatile ("movl (%eax),%edi");                                      // mov edi,[eax]
  asm volatile ("movl %%edi,(%0)(%%esi)" :"=m"(SdtHooks):);               // mov [esi+SdtHooks], edi
  asm volatile ("pop %edi");                                              // pop edi
  asm volatile ("movl %ebx,(%edi)");                                      // mov [edi],ebx
  asm volatile ("incl %ecx");                                             // inc ecx
  asm volatile ("incl %0" :"=m"(NumFixEntries):);                         // inc NumFixEntries
  asm volatile ("addl %0,%%esi" : :"i"(4));                               // add esi,4
  asm volatile ("addl %0,%%edx" : :"i"(4));                               // add edx,4
  asm volatile ("jmp loope");                                             // jmp loope
  asm volatile ("ret_lejos: sti");                                        // ret_lejos:
                                                                          // sti
  asm volatile ("popf");                                                  // popfd
  asm volatile ("popa");                                                  // popad
  asm volatile ("mov %ebp,%esp");                                         // mov esp,ebp
  asm volatile ("pop %ebp");                                              // pop ebp
  asm volatile ("lret");                                                  // retf (retf num_param * 2)
}

int main(void)
{
    BOOL flag = 0;
    WORD farcall[4];
    ULONG Ring0CodeLength = 0;
    HANDLE Thread;
    int sdt_ctr;
    char *choice;
    DWORD sdt_ptr;
    
    if(get_windows_version() == OS_WXP)
    {
        SetProcessAffinityMask(GetCurrentProcess(), 1L);
    
        SetProcessWorkingSetSize(GetCurrentProcess(), 2048000L, 3072000L);
        
        printf("-- [ SDT Cleaner 1.0 - SV (Stable Version) ] --\n\n");
		printf("[ Coded by: Nahuel C. Riva - Core Security Technologies ]\n");
		printf("[ Buenos Aires, Argentina ]\n\n");
        printf("[+] SDT information\n");
        SdtAddrs[0] = getSdtAddrsAndPtrs(&sdt_ptr,0);
        SdtPtrs[0]  = sdt_ptr;
        printf("[+] SDT Address: \t\t [ 0x%x ]\n", SdtAddrs[0]);
        printf("[+] SDT Pointer: \t\t [ 0x%x ]\n", SdtPtrs[0]);
        printf("\nGetting SDT Function Addrs and Ptrs, please wait...\n");

        for(sdt_ctr = 1; sdt_ctr < KI_SERVICE_LIMIT; sdt_ctr++)
        {
           SdtAddrs[sdt_ctr] = getSdtAddrsAndPtrs(&sdt_ptr,sdt_ctr);
           SdtPtrs[sdt_ctr]  = (DWORD)sdt_ptr;
        }
        
        flag = ChangeDevPhysicalMemRights();
        if(flag)
        {
           farcall[2] = GdtMap[0].Segment;
           
           printf("[+] GdtMap[0].Segment: \t\t [ 0x%08x ]\n", GdtMap[0].Segment);
           Ring0CodeLength = ( ULONG )( ( unsigned char * )main - ( unsigned char * )RestoreSdtPtrs );
           
           printf("\n\n-- [ Information Collected Successfully ] --\n\n");
           printf("WARNING: FIXING THE SDT MAY CRASH THE SYSTEM. PROCEED AT YOUR OWN RISK.\n\n");
           printf("Do you want to proceed?\n\nOptions -> yes(y) / no(n):");
           choice = (char *)getchar();
           if(tolower(choice) == 'y')
           {
               if( 0 == VirtualLock( RestoreSdtPtrs, Ring0CodeLength ))
                   printf("ERROR: VirtualLock failed\n");
               else
               {            
                    Thread = GetCurrentThread();
                    SetThreadPriority(Thread, THREAD_PRIORITY_TIME_CRITICAL);
                    Sleep(0);
                    
                    // ring0 code execution
                    asm volatile ("lcall *(%0)" : :"g" (farcall));
        			if(NumFixEntries)
        			{
                       printf("\n\n-- [ Number of fixed entries: %d ] --\n\n", NumFixEntries);
                       
                       int i;
                       for(i = 0; i < NumFixEntries; i++)
                          printf("-- Fixed Entry [ Ptr: 0x%08x at Addr: 0x%08x ]\n", SdtHooks[i], SdtAddrsFix[i]);
                    }
                    else printf("\n\n-- [ No hooks detected in SDT ] --");
                    getch();		
                    SetThreadPriority( Thread, THREAD_PRIORITY_NORMAL );
        			VirtualUnlock( RestoreSdtPtrs, Ring0CodeLength );
               }
             UninstallCallgate((DWORD)RestoreSdtPtrs, 0);  
          }
        }
        else
           printf("ERROR: Callgate was not installed\n");
    }
    else
    { 
       printf("-- [ System Not Supported Yet, Sorry ] --");
       getch();
    }
    return 0;    
}
